/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.peers.Logger;

public class FileLogger
implements Logger {
    public static final String LOG_FILE = File.separator + "logs" + File.separator + "peers.log";
    public static final String NETWORK_FILE = File.separator + "logs" + File.separator + "transport.log";
    private PrintWriter logWriter;
    private PrintWriter networkWriter;
    private Object logMutex;
    private Object networkMutex;
    private SimpleDateFormat logFormatter;
    private SimpleDateFormat networkFormatter;

    public FileLogger(String peersHome) {
        if (peersHome == null) {
            peersHome = ".";
        }
        try {
            this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(peersHome + LOG_FILE)));
            this.networkWriter = new PrintWriter(new BufferedWriter(new FileWriter(peersHome + NETWORK_FILE)));
        }
        catch (IOException e) {
            System.out.println("logging to stdout");
            this.logWriter = new PrintWriter(System.out);
            this.networkWriter = new PrintWriter(System.out);
        }
        this.logMutex = new Object();
        this.networkMutex = new Object();
        this.logFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        this.networkFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void debug(String message) {
        Object object = this.logMutex;
        synchronized (object) {
            this.logWriter.write(this.genericLog(message.toString(), "DEBUG"));
            this.logWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void info(String message) {
        Object object = this.logMutex;
        synchronized (object) {
            this.logWriter.write(this.genericLog(message.toString(), "INFO "));
            this.logWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void error(String message) {
        Object object = this.logMutex;
        synchronized (object) {
            this.logWriter.write(this.genericLog(message.toString(), "ERROR"));
            this.logWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void error(String message, Exception exception) {
        Object object = this.logMutex;
        synchronized (object) {
            this.logWriter.write(this.genericLog(message, "ERROR"));
            exception.printStackTrace(this.logWriter);
            this.logWriter.flush();
        }
    }

    private final String genericLog(String message, String level) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.logFormatter.format(new Date()));
        buf.append(" ");
        buf.append(level);
        buf.append(" [");
        buf.append(Thread.currentThread().getName());
        buf.append("] ");
        buf.append(message);
        buf.append("\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void traceNetwork(String message, String direction) {
        Object object = this.networkMutex;
        synchronized (object) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.networkFormatter.format(new Date()));
            buf.append(" ");
            buf.append(direction);
            buf.append(" [");
            buf.append(Thread.currentThread().getName());
            buf.append("]\n\n");
            buf.append(message);
            buf.append("\n");
            this.networkWriter.write(buf.toString());
            this.networkWriter.flush();
        }
    }
}

